import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:search_drop_down/dropdowns/custom_dropdown.dart';
import 'package:admin_desktop/application/bookings/booking_provider.dart';
import 'package:admin_desktop/application/masters/accepted_masters/accepted_masters_provider.dart';

class TestPage extends ConsumerStatefulWidget {
  const TestPage({super.key});

  @override
  ConsumerState<TestPage> createState() => _TestPageState();
}

class _TestPageState extends ConsumerState<TestPage> {
  @override
  void initState() {
    WidgetsBinding.instance.addPostFrameCallback((_) {
      ref.read(bookingProvider.notifier).fetchBookings(
            context: context,
            isRefresh: true,
            startTime: DateTime.now(),
            endTime: DateTime.now(),
          );
      ref.read(acceptedMastersProvider.notifier).fetchMembers(isRefresh: true);
    });
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    final state = ref.watch(acceptedMastersProvider);
    return Scaffold(
      body: Column(
        mainAxisAlignment: MainAxisAlignment.center,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          CustomDropdown(
            list: state.users.map((e) {
              return e.firstname ?? "";
            }).toList(),
            onSearching: (s) {
              ref.read(acceptedMastersProvider.notifier).setMastersQuery(
                    context,
                    s,
                  );
            },
            isLoading: state.isLoading,
          )
        ],
      ),
    );
  }
}
